#!/usr/bin/env python
# -*- coding: utf-8 -*-

# PhotoLab :: Jpeg Quality
# Copyright Raymond Ostertag 2009
# Licence GPL

# Version 1.0
# - initial release

# Installation : put the photolab_template.py file in your $HOME/.gimp-2.n/plug-ins.
# On Linux and Mac OSX the file must be executable.
# Documentation : http://www.gimp.org/docs/python/index.html
# Źródło: http://gimpfr.org/contrib_photolabo.php#JpegQuality
""" To podstawowe narzędzie do pracy wsadowej dla zwiększenia stopnia 
 kompresji Naszych zdjęć JPEG, a tym samym zmniejszania ciężaru plików 
 bez zmniejszania wymiaru w pikselach. Nie zawsze jest przydatne, aby
 zachować maksymalną jakość swoich zdjęć w formacie JPEG, jeżeli chceszmy
 na przykład umieścić je wszystkie na płycie CD i wysłać je do znajomych.
"""

from gimpfu import *
import os, glob, shutil
 # Moduł shutil oferuje szereg operacji na wysokim szczeblu na temat plików 
 # i kolekcji plików. W szczególności wspiera funkcje kopiowania i usuwania pliku.
 # W przypadku operacji na indewidualnych plikach, patrz również Moduł os.


# Stałe
#
minQuality = 50 
maxQuality = 98 
smoothing = 0.0 
optimize = 1
comment = ""
subsmp = 0
baseline = 0
restart= 0
dct = 0



import gettext
locale_directory = gimp.locale_directory
gettext.install( "gimp20-photolab" , locale_directory, unicode=True )



# export nazwy
#         
def python_fu_photolab_jpegq_exportname(inImage, toDirectory, quality):
  imageName = pdb.gimp_image_get_name( inImage )
  imageBasename = os.path.splitext( imageName )[0]
  imageExtname = os.path.splitext( imageName )[1]
  if imageExtname == "" or imageExtname == ".xcf" :
    imageExtname = ".jpg"
  newfilepathname = toDirectory + os.sep + imageBasename + '_JPEGQ' + str(int(quality)) + imageExtname 
  return newfilepathname  

# Główny Program
#
def photolab_jpegq(dirname, ext, copy, toDirectory, quality, progressive):
  if os.path.exists( u''+dirname ):
    #
    globpattern = u''+dirname + os.sep + '*.' + ext
    filepathnames = glob.glob( globpattern ) # return complete path name of files
    #
    if filepathnames:
      #Start procesu
      #DEBUG pdb.gimp_message( _("The selected directory has %s files to handle") %(str( len( filepathnames ))));
      for filepathname in filepathnames:
        img= pdb.gimp_file_load( filepathname , filepathname )
        imglayer= img.layers[0]
        #
        if copy :
          jpegqfilepathname = python_fu_photolab_jpegq_exportname( img, toDirectory, quality )
        else:
          jpegqfilepathname = filepathname
        pdb.file_jpeg_save( img, imglayer, jpegqfilepathname, jpegqfilepathname, float(quality)/100.0, float(smoothing), optimize, int(progressive), comment, subsmp, baseline, restart, dct)
        gimp.delete( img )
      # koniec procesu         
    else:
      pdb.gimp_message( _("%s nie ma plików do obsługi") %(dirname )) # Wiadomość pojawia się w Konsoli błędów 
	  # gdy w Katalogu nie ma plików do obsługi     
  else:
    pdb.gimp_message( _("%s nie istnieją") %(dirname) )

register(
  "photolab-jpegQ",
  "Proces wsadowy na zdjęciach w katalogu.\n Ustawianie ich jakości JPEG "+"\n "+__file__,
  "Proces wsadowy na zdjęciach w katalogu. Ustawianie jakości JPEG. Przydatne, aby zmniejszyć ciężar JPEG bez zmniejszania wymiaru w pikselach, przed wysłaniem ich do internetu.",
  "Raymond Ostertag, Modified Zbyma72age",
  "GPL License",
  "2009, Modified 2015",
  "Jakość Jpeg...",
  "",
  [
    (PF_DIRNAME, "directory", _("Katalog"), os.getcwd() ),
    (PF_STRING, "ext", _("Rozszerzenie pliku"), "jpg" ),
    (PF_TOGGLE, "copy", _("Utwórz kopię"), True), #bool
    (PF_DIRNAME, "toDirectory", ".."+_("Katalog docelowy"), os.getcwd() ),  
    (PF_SPINNER, "quality", _("Jakość"), 85, (minQuality,maxQuality,1)), #int
    (PF_TOGGLE, "progressive", _("Ładuj obrazy progresywnie (Web)"), True), #bool
  ],
  [],
  photolab_jpegq,
  menu="<Image>/TEST",
  domain=("gimp20-photolab", locale_directory)   
  )

main()
